<?php if(isset($tour_one) && !empty($tour_one['single'])): ?>
    <section class="tour-section fix section-padding">
        <div class="container">
            <div class="section-title text-center">
                <span class="wow fadeInUp"><?php echo e($tour_one['single']['title'] ?? ''); ?></span>
                <h2 class="wow fadeInUp" data-wow-delay=".3s"><?php echo e($tour_one['single']['sub_title'] ?? ''); ?></h2>
                <p class="mt-3 mt-mb-0 wow fadeInUp" data-wow-delay=".5s">
                    <?php echo e($tour_one['single']['description'] ?? ''); ?>

                </p>
            </div>
            <div class="row">
                <?php $__currentLoopData = $tour_one['packages'] ?? []; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $package): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <div class="col-xl-3 col-lg-6 col-md-6 wow fadeInUp" data-wow-delay=".2s">
                        <div class="tour-box-items tour-single">
                            <div class="tour-box-items-inner">
                                <div class="thumb">
                                    <img src="<?php echo e(getFile($package->thumb_driver, $package->thumb)); ?>" alt="<?php echo e($package->title ?? ''); ?>">
                                </div>
                                <div class="content">
                                    <span><?php echo e($package->countryTake->name ?? ''); ?></span>
                                    <h4>
                                        <a href="<?php echo e(route('package.details', $package->slug)); ?>">
                                            <?php echo app('translator')->get($package->title); ?>
                                        </a>
                                    </h4>
                                    <h6><?php echo app('translator')->get('From'); ?>
                                        <span><?php echo e(discountPrice($package)); ?></span>
                                        <?php if($package->discount == 1): ?>
                                            <del><?php echo e($package->adult_price ?? 0); ?></del>
                                        <?php endif; ?>
                                    </h6>
                                    <ul class="list">
                                        <li>
                                            <i class="far fa-calendar"></i>
                                            <?php echo e($package->duration ?? ''); ?>

                                        </li>
                                        <li>
                                            <i class="far fa-flag"></i>
                                            <?php echo e($package->place_count .' places'); ?>

                                        </li>
                                    </ul>
                                </div>
                            </div>

                        </div>
                    </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>
        </div>
    </section>
<?php endif; ?>

<?php /**PATH D:\server\htdocs\tripvendor\live\resources\views/themes/adventra/sections/tour_one.blade.php ENDPATH**/ ?>